package gov.va.vinci.dart.db.mock;

import java.util.HashSet;

import gov.va.vinci.dart.biz.Activity;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.db.ActivityDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

public class ActivityDAOMock implements ActivityDAO {

	private static int idCounter = 1;

	// allocate an id for the activity but leave it to ResearchStdyDAO and OperationalStudyDAO to save the object in their hashes.
	@Override
	public synchronized void save(final Activity activity) {
		if (activity == null) {
			throw new IllegalArgumentException();
		}

		if (activity.getId() == 0) {
			activity.setId(idCounter++);
		}
		
		if (activity.getRequests() == null) {
			activity.setRequests(new HashSet<Request>());
		}
	}

	@Override
	public Activity findById(int activityId) {
		
		Activity result = DartObjectFactory.getInstance().getResearchStudyDAO().findById(activityId);
		
		if (result == null) {
			result = DartObjectFactory.getInstance().getOperationalStudyDAO().findById(activityId);
		}
		
		return result;
	}

}
